#pragma once

#include "stdafx.h"
#include "afxcmn.h"
#include "afxwin.h"

// CPCanIsoTpExampleDlgMessages dialog
class CPCanIsoTpExampleDlgMessages : public CDialogEx
{
	friend class CPcanIsoTpExampleDlg;
	DECLARE_DYNAMIC(CPCanIsoTpExampleDlgMessages)
public:
	CPCanIsoTpExampleDlgMessages(TPCANTPHandle *p_pctpHandle, CWnd* pParent = NULL);   // standard constructor
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_PCANISOTPEXAMPLE_TAB_MESSAGES };
#endif

public_member:
	TPCANTPHandle *m_pctpHandle; // Handle selected on combobox Channel
	/// <summary>
	/// Thread used to read CANTP messages via timer.
	/// </summary>
	HANDLE m_readThread;
	/// <summary>
	/// Handle on event when a CAN message is coming.
	/// </summary>
	HANDLE m_eventHandleToReadCAN;
	/// <summary>
	/// Handle on event to stop thread when a different mode is selected (manual or timer).
	/// </summary>
	HANDLE m_eventHandleToStopWaitingForObject;
	/// <summary>
	/// Thread used to read CANTP messages via events.
	/// </summary>
	HANDLE m_eventThread;
	bool m_stopReadThread;
	/// <summary>
	/// Lock to prevent a multiple access on UI object.
	/// </summary>
	CCriticalSection _criticalSection;
	/// <summary>
	/// List of received messages
	/// </summary>
	std::vector<MessageStatus*> m_receiveMsgs;
	int m_msgUpdateIndex;
	CString m_lastGoodMessage;
	CPcanIsoTpExampleDlg* m_dlgParent;

public_method:
	void FillComboMappings();
	void TerminateReadThread();
	void ProcessMessage(TPCANTPMsg p_msgRcvd, TPCANTPTimestamp p_ts);
	void InsertMsgEntry(TPCANTPMsg p_msg, TPCANTPTimestamp p_ts);
	void AddData(CListCtrl& p_ctrl, int p_row, int p_col, const wchar_t* p_str);
	void CleanReceivedMessagesList();
	static DWORD WINAPI CanReadThread(LPVOID p_lpParam);
	static DWORD WINAPI CanReadThreadForEvent(LPVOID p_lpParam);
	TPCANTPStatus ReadMessage();
	void readMessages();
	void ManageUIForFD(bool p_state);

protected_method:
	DECLARE_MESSAGE_MAP()
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	afx_msg void OnBnClickedButtonFill();
	afx_msg void OnEnUpdateEditData();
	afx_msg void OnDeltaposSpinLength(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedRadioTimer();
	afx_msg void OnBnClickedRadioEvent();
	afx_msg void OnBnClickedRadioManual();
	afx_msg void OnBnClickedButtonRead();
	afx_msg void OnBnClickedButtonClear();
	afx_msg void OnBnClickedButtonWrite();
	afx_msg void OnCbnSelchangeComboMapping();
	afx_msg void OnBnClickedCheckFd();
	afx_msg void OnBnClickedCheckHasPriority();

public_properties:
	// Dialog Data
	CButton buttonMsgClear;
	CButton buttonMsgDataFill;
	CButton buttonMsgRead;
	CButton buttonMsgWrite;
	CButton checkBoxMsgShowPeriod;
	CComboBox comboBoxMsgMapping;
	CEdit textBoxMsgData;
	CEdit editLength;
	CEdit editRemote;
	CEdit editSource;
	CEdit editTarget;
	CListCtrl listViewMsgs;
	CSpinButtonCtrl numericUpDownRemoteAddr;
	CSpinButtonCtrl numericUpDownMsgLength;
	CSpinButtonCtrl numericUpDownSourceAddr;
	CSpinButtonCtrl numericUpDownTargetAddr;
	CButton radioButtonMsgTimer;
	CButton radioButtonMsgEvent;
	CButton radioButtonMsgManual;
	CSpinButtonCtrl numericUpDownPriority;
	CEdit editPriority;
	CButton checkBoxFDMessage;
	CButton checkBoxBRS;
	CButton checkBoxHasPriority;
};
